/*
	BDS Welcome Page - RSS Display Module

	Copyright (c) 2004, 2005 Borland Software Corporation

	Written by Daniel Wischnewski, Borland SE Germany.
	Co-Admin of www.delphipraxis.net -- The German Delphi Community
	Email: dwischnewski@gatenetwork.com
*/

var FEED_OK = 00;
var FEED_OFFLINE = 01;
var FEED_CACHE = 02;
var FEED_CONN_ERROR = 10;
var FEED_NODATA = 11;
var FEED_XML4_ERROR = 12;
var FEED_OFFLINE_NODATA = 13;

function displayRss(docNode, xmlSource, xslSource)
{
	try
	{
		docNode.innerHTML = xmlSource.transformNode(xslSource);
		docNode.style.visibility = 'visible';
	} catch(e) {
		docNode.style.visibility = 'hidden';
		debugAlert(e.message);
	}
}

function determineDefaultFeed()
{
	var item;
	var xmlDefault;

	// check personal settings
	item = getSubNode(getSettingsNode(xmlPersonal), 'defaultFeed');
	if (getItemValue(item, 'link') == '')
	{
		xmlDefault = loadLocalXmlDoc('rssFeeds.xml');
		item = xmlDefault.selectSingleNode('.//item[@default]');
		if (item == null)
		{
			item = xmlDefault.selectSingleNode('.//item');
		}
	}
	return item;
}

function doDownloadNews(xmlHTTP, linkUrl)
{
	var lResolve;
	var lConnect;
	var lSend;
	var lReceive;
	var xmlDoc;

	if (!clientIsOnline)
	{
		return null;
	}

	try
	{
		lResolve = 20 * 1000;    // Timeout values are in milli-seconds
		lConnect = 30 * 1000;
		lSend = 30 * 1000;
		lReceive = 30 * 1000;
		xmlHTTP.setTimeouts(lResolve, lConnect, lSend, lReceive);
		if (clientUsesProxy & clientProxyString != "")
		{
			xmlHTTP.setProxy(2, clientProxyString);
		}
		xmlHTTP.open("GET", linkUrl, false);
		if (clientProxyUser != "" && clientProxyPassword != "")
		{
			xmlHTTP.setProxyCredentials(clientProxyUser, clientProxyPassword);
		}
		xmlHTTP.setRequestHeader("User-Agent", clientUserAgentString);
		xmlHTTP.send();
		if (xmlHTTP.status != 200)
		{
			debugAlert("HTTP Status: " + xmlHTTP.status);
			return null;
		}
	} catch(e) {
		debugAlert("JS Error Message: " + e.message);
		setClientIsOnline(false);
		return null;
	}
    try
    {
		xmlDoc = getXmlDoc();
		xmlDoc.load(xmlHTTP.responseStream);
		if (xmlDoc.parseError.errorCode == 0)
		{
			return xmlDoc;
		} else {
			debugAlert("XML Error Code: " + xmlDoc.parseError.errorCode);
			return null;
		}
	} catch(e) {
		debugAlert("JS Error Message: " + e.message);
		return null;
	}
}

function doGetNews(localContent, cacheXml, date)
{
	var xmlHTTP;
	var xmlDoc;

	try
	{
		xmlHTTP = getXmlHttpDoc();
	} catch(e) {
		return FEED_XML4_ERROR;
	}

	if (getItemValue(cacheXml, "@link").indexOf("://") >= 0)
	{
		isLocal = false;
		try
		{
			if(localContent == null)
			{
				xmlDoc = doDownloadNews(xmlHTTP, getItemValue(cacheXml, "@link"));
				if (xmlDoc == null)
				{
					return FEED_CONN_ERROR;
				}
			} else {
				xmlDoc = getXmlDoc();
				xmlDoc.load(wpPath + getItemValue(cacheXml, "@link"));
			}
		} catch(e) {
			return FEED_CONN_ERROR;
		}
	} else {
		isLocal = true;
		xmlDoc = getXmlDoc();
		xmlDoc.load(wpPath + getItemValue(cacheXml, "@link"));
		if (xmlDoc.parseError.errorCode != 0) {
			xmlDoc.load(getItemValue(cacheXml, "@link"));
		}
	}
	// quick'n dirty remove off all subnodes
	cacheXml.text = "";
	items = xmlDoc.getElementsByTagName("channel");
	for (var i = 0; i < items.length; i++)
	{
		cacheXml.appendChild(items[i]);
	}

	if (!isLocal)
	{
		setAttrValue(cacheXml, "lastLoad", date.toLocaleDateString());
		saveRssCache();
	}

	return FEED_OK;
}

function getFeed(feedDataNode)
{
	var date;
	var downloadNews;
	var rssDoc;
	downloadNews = false;
	date = new Date();
	// check cached feed data
	if (getItemValue(feedDataNode, "reload") == "1")
	{
		downloadNews = true;
		feedDataNode.removeChild(getSubNode(feedDataNode, "reload"));
	}
	URI = getItemValue(feedDataNode, "link");
	currentFeed = URI;
	cacheXml = getSubNodeEx(xmlRssCache.documentElement, "rss", "link", URI);
	if (getItemValue(cacheXml, "@lastLoad") != date.toLocaleDateString())
	{
		downloadNews = true;
	}
	if (downloadNews)
	{
		downloadResult = doGetNews(feedDataNode.getAttributeNode("localcontent"), cacheXml, date);
	} else {
		downloadResult = FEED_CACHE;
	}
	rssDoc = getXmlDoc();
	rssDoc.appendChild(cacheXml.cloneNode(true));

	return rssDoc;
}

function saveSettings(selectBox)
{
	var idx;
	var dummy;
	var reload;
	var newFeedUrl;
	var newFeedTxt;
	var defaultFeed;

	idx = selectBox.selectedIndex;
	dummy = selectBox[idx].value.split(";");
	reload = dummy[0];
	newFeedUrl = dummy[1];
	newFeedTxt = selectBox[idx].text;

	defaultFeed = getSubNode(getSettingsNode(xmlPersonal), 'defaultFeed');
	getSubNode(defaultFeed, 'link').text = newFeedUrl;
	getSubNode(defaultFeed, 'title').text = newFeedTxt;
	getSubNode(defaultFeed, 'reload').text = reload;
}

function displayThisRss(rssDocument)
{
	displayRss(rssContent, rssDocument, loadLocalXslDoc('rssFeeds.xsl'));
}

function displayDefaultRss()
{
	displayThisRss(getFeed(determineDefaultFeed(xmlPersonal)));
}

function rssFeedSelected()
{
	var selectBox;

	selectBox = document.getElementById('rssFeeds');

	if (!selectBox[selectBox.selectedIndex].disabled) {
		saveSettings(selectBox);
		setClientIsOnline(external.Application.IsOnline)
		displayDefaultRss();
		savePersonalSettings();
	}
}

function clearRssCache()
{
	var rootNode;
	var nodesCache;

	rootNode = xmlRssCache.documentElement;
	nodesCache = rootNode.selectNodes('rss');
	for (var i = 0; i < nodesCache.length; i++)
	{
		rootNode.removeChild(nodesCache.item(i));
	}
	
	saveRssCache();
	rssFeedSelected();
}

function showRss(rssSourceFile)
{
	displayRss(rssContent, loadXmlDoc(rssSourceFile), loadLocalXslDoc('rssFeeds.xsl'));
}

function getCurrentVersion(id, updateURL, originalVersion)
{
	var cacheXml;
	var date;
	var xmlHTTP;
	var xmlDoc;
	var items;

	try
	{
		xmlHTTP = getXmlHttpDoc();
		date = new Date();
		cacheXml = getSubNodeEx(getSettingsNode(xmlPersonal), 'rss', 'id', id);
		
		if (getItemValue(cacheXml, "@lastLoad") != date.toLocaleDateString())
		{
			xmlDoc = doDownloadNews(xmlHTTP, updateURL);
		}
		if (xmlDoc != null)
		{
			setAttrValue(cacheXml, "lastLoad", date.toLocaleDateString());
			items = xmlDoc.getElementsByTagName("channel");
			cacheXml.text = "";
			for (var i = 0; i < items.length; i++)
			{
				cacheXml.appendChild(items[i]);
			}
			savePersonalSettings();
		}
		if (cacheXml.selectNodes('channel').length > 0)
		{
			return cacheXml;
		} else {
			return loadXmlDoc(originalVersion);
		}
	} catch(e) {
	}
}
